import argparse

"""
Here are the param for the training

"""


def get_args():
    parser = argparse.ArgumentParser("Reinforcement Learning experiments for multiagent environments")
    # Policy
    parser.add_argument("--policy", type=str, default="ICP", help="type of policy")
    parser.add_argument("--cuda", type=bool, default=True, help="use gpu:0")
    parser.add_argument("--seed", type=int, default=12123, help="seed")
    parser.add_argument("--grad-clip", type=float, default=10, help="grad_clip")
    parser.add_argument("--vec-env", type=int, default=100, help="vec-env")

    parser.add_argument("--hidden-size", type=int, default=256, help="network hidden size")
    parser.add_argument("--rnn-layers", type=int, default=2, help="bum of rnn layers")

    parser.add_argument("--eps", type=float, default=0.1, help="eps")

    # Environment
    parser.add_argument("--scenario-name", type=str, default="GuessingNumber", help="name of the scenario script")
    parser.add_argument("--max-episode-len", type=int, default=100, help="maximum episode length")
    parser.add_argument("--time-steps", type=int, default=2000000, help="number of time steps")

    # Core training parameters
    parser.add_argument("--lr", type=float, default=5e-4, help="learning rate of actor")
    parser.add_argument("--target-update-rate", type=int, default=100, help="learning rate of critic")
    # NO epsilon AS USE Gumbel_softmax
    # parser.add_argument("--epsilon", type=float, default=0.1, help="epsilon greedy")
    # parser.add_argument("--noise_rate", type=float, default=0.1, help="noise rate for sampling from a standard normal distribution ")
    parser.add_argument("--gamma", type=float, default=0.99, help="discount factor")

    # Checkpointing
    parser.add_argument("--save-dir", type=str, default="./model/5/seed_12124", help="directory in which training state and model should be saved")
    parser.add_argument("--save-rate", type=int, default=2000, help="save model once every time this many episodes are completed")
    parser.add_argument("--model-dir", type=str, default="", help="directory in which training state and model are loaded")

    # Evaluate
    parser.add_argument("--evaluate-episodes", type=int, default=1, help="number of episodes for evaluating")
    parser.add_argument("--evaluate", type=bool, default=False, help="whether to evaluate the model")
    parser.add_argument("--evaluate-rate", type=int, default=50, help="how often to evaluate model")
    args = parser.parse_args()

    return args
